# @copyright (c) 2002-2014 Acronis International GmbH. All rights reserved.

from jinja2.ext import GETTEXT_FUNCTIONS
from jinja2.utils import LRUCache
import gettext
import os

__all__ = ['get_translations', 'get_functions']

__translations = LRUCache(50)


def __get_languages(locale_dir, domain):
    try:
        return [x for x in os.listdir(locale_dir) if os.path.exists(os.path.join(locale_dir, x, 'LC_MESSAGES', domain + '.mo'))]
    except FileNotFoundError:
        return []


def __load_translations(locales_dir, domain):
    return {
        language: gettext.translation(domain, locales_dir, languages=[language], fallback=True) for language in __get_languages(locales_dir, domain)
    }


def get_translations(locales_dir, domain):
    translation = __translations.get((locales_dir, domain))
    if translation is None:
        __translations[(locales_dir, domain)] = translation = __load_translations(locales_dir, domain)
    return translation


def get_functions(translation):
    return {k: getattr(translation, k) for k in ['gettext', 'ngettext']}
