# @copyright (c) 2002-2013 Acronis International GmbH. All rights reserved.

from . import api
from urllib.request import HTTPCookieProcessor


class Session:
    def __init__(self):
        self.processors = [HTTPCookieProcessor()]

    def delete(self, url, **kwargs):
        return api.delete(url, processors=self.processors, **kwargs)

    def head(self, url, **kwargs):
        return api.head(url, processors=self.processors, **kwargs)

    def get(self, url, **kwargs):
        return api.get(url, processors=self.processors, **kwargs)

    def post(self, url, data=None, **kwargs):
        return api.post(url, data=data, processors=self.processors, **kwargs)

    def put(self, url, data=None, **kwargs):
        return api.put(url, data=data, processors=self.processors, **kwargs)
