# @copyright (c) 2002-2014 Acronis International GmbH. All rights reserved.

from .translations import get_translations
from .template import get_loader as get_template_loader, clear_loader_cache


def get_loader_for_application(*args, **kwargs):
    import os
    _root = appconfig['templates']['path']
    _search_path = [os.path.join(_root, x) for x in args]
    _search_path.append(_root)
    _translations = get_translations(appconfig['locales']['path'], appconfig['locales']['domain'])
    return get_template_loader(_search_path, _translations, globals=kwargs)
