# @copyright (c) 2002-2013 Acronis International GmbH. All rights reserved.

from urllib.request import BaseHandler, HTTPRedirectHandler, HTTPError, Request
import base64


class HTTPBaseAuthProcessor(BaseHandler):
    def __init__(self, username, password):
        self.credentials = 'Basic {0}'.format(base64.standard_b64encode('{}:{}'.format(username, password).encode('utf8')).decode('utf8'))

    def http_request(self, request):
        request.add_header('Authorization', self.credentials)
        return request

    https_request = http_request


class HTTPRedirectProcessor(HTTPRedirectHandler):
    def redirect_request(self, req, fp, code, msg, headers, newurl):
        """
            TODO need to send patch to python community
            There is bug in HTTPRedirectHandler, it does not safe method when do redirect
        """
        m = req.get_method()
        read_redirect_allowed = m in ('GET', 'HEAD') and code in (301, 302, 303, 307)
        write_redirect_allowed = m in ('POST', 'PUT', 'DELETE') and code in (301, 302, 303)
        if not (read_redirect_allowed or write_redirect_allowed):
            raise HTTPError(req.full_url, code, msg, headers, fp)

        return Request(newurl.replace(' ', '%20'),
                       headers=req.headers,
                       origin_req_host=req.origin_req_host,
                       unverifiable=True, method=m, data=req.data)
