# @copyright (c) 2002-2013 Acronis International GmbH. All rights reserved.

import logging
import sys
import traceback


def exception_hook(exc_t, exc_v, tb):
    if not issubclass(exc_t, (KeyboardInterrupt, SystemExit)):
        logging.error('*** Uncaught exception ***')
        logging.error(''.join(traceback.format_exception(exc_t, exc_v, tb)))


def setup():
    sys.excepthook = exception_hook
