import os
import sysconfig

_CA_FILE = None
_CA_DATA = None

try:
    _CA_FILE = os.path.normpath(os.path.join(sysconfig.get_path('data'), 'ca-certificates/certdata.pem'))
except KeyError as _:
    pass

if _CA_FILE is None:
    try:
        import _certifi_frozen
        _CA_DATA = _certifi_frozen.CERTDATA
    except ImportError as _:
        pass


def _cadata_unlink(name):
    try:
        os.unlink(name)
    except Exception as _:
        pass


def where():
    global _CA_FILE
    if _CA_FILE is not None:
        return _CA_FILE
    if _CA_DATA is not None:
        import atexit
        import tempfile
        fd = None
        try:
            fd, name = tempfile.mkstemp(suffix='-certdata.pem')
            os.write(fd, _CA_DATA.encode('ascii'))
        finally:
            if fd is not None:
                os.close(fd)
        atexit.register(_cadata_unlink, name)
        _CA_FILE = name
    return _CA_FILE


def contents():
    if _CA_DATA is not None:
        return _CA_DATA
    if _CA_FILE is not None:
        with open(_CA_FILE, 'rt') as fh:
            return fh.read()
    return None
