ORIGIN_TYPE_UNKNOWN = 0
ORIGIN_TYPE_LOCAL = 1
ORIGIN_TYPE_CENTRALIZED = 2
ORIGIN_TYPE_CENTRALIZELY_DEPLOYED = 3


UNKNOWN_LOCATION = 0
LOCAL_FOLDER_LOCATION = 1
NETWORK_SHARE_LOCATION = 2
FTP_LOCATION = 3
SFTP_LOCATION = 4
CD_LOCATION = 5
TAPE_LOCATION = 6
STORAGE_SERVER_LOCATION = 7
ASZ_LOCATION = 8
REMOVABLE_DRIVE_LOCATION = 9
ONLINE_LOCATION = 10
NFS_SHARE_LOCATION = 11
ESX_LOCATION = 12


DESTINATION_LOCATION_URI_GLOBAL = 0
DESTINATION_LOCATION_URI_LOCAL = 1


BACKUP_SCHEME_NOW = 0
BACKUP_SCHEME_ONCE = 1
BACKUP_SCHEME_SIMPLE = 2
BACKUP_SCHEME_GFS = 3
BACKUP_SCHEME_TOWER_OF_HANOI = 4
BACKUP_SCHEME_CUSTOM = 5
BACKUP_SCHEME_INITIAL_SEEDING_NOW = 6
BACKUP_SCHEME_INITIAL_SEEDING_ONCE = 7
BACKUP_SCHEME_CDP = 8
REPLICATION_SCHEME_ONCE = 9
REPLICATION_SCHEME_SIMPLE = 10
BACKUP_SCHEME_ALWAYS_FULL = 20
BACKUP_SCHEME_ALWAYS_INCREMENTAL = 21
BACKUP_SCHEME_WEEKLY_FULL_DAILY_INCR = 22
BACKUP_SCHEME_MONTHLY_FULL_WEEKLY_DIFF_DAILY_INCR = 23

BACKUP_TYPE_FULL = 0
BACKUP_TYPE_INCREMENTAL = 1
BACKUP_TYPE_DIFFERENTIAL = 2
BACKUP_TYPE_CONTINUOUS = 3
BACKUP_TYPE_INCREMENTAL_AS_SYNTHETIC_FULL = 4

BACKUP_DATA_TYPE_BINARY = 0
BACKUP_DATA_TYPE_JOURNAL = 1

INFINITE_PERIOD = -1

ACTION_TYPE_DROP = 1
ACTION_TYPE_RUN = 2

BACKUP_TYPE_LOCAL_FILES = 'gct::files'
BACKUP_TYPE_CENTRALIZED_FILES = 'gct::centralized_files'
BACKUP_TYPE_DISKS = 'gct::disks'
BACKUP_TYPE_SQL = 'ars::db::items'
BACKUP_TYPE_EXCHANGE = 'arx::db::infostore_items'
BACKUP_TYPE_SYSTEM_STATE = 'gct::system_state'

DEFAULT_PLAN_NAME_FOR_PROTECT_NOW = 'Backup Now'

TAG_URI_ASZ = 'atis:///asz'

TAG_GTOB_DTO_PROTECTION_SOURCE = 'Gtob::Dto::ProtectionSource'
TAG_GTOB_DTO_PROTECTION_SET = 'Gtob::Dto::ProtectionSet'
TAG_GTOB_DTO_STAGE = 'Gtob::Dto::Stage'
TAG_GTOB_DTO_STAGING_RULES = 'Gtob::Dto::StagingRules'
TAG_GTOB_DTO_PROTECTION_PLAN = 'Gtob::Dto::ProtectionPlan'
TAG_GTOB_DTO_RUN_NOW_PARAMETERS = 'Gtob::Dto::BackupNowParameters'
TAG_GTOB_DTO_RUN_ONCE_PARAMETERS = 'Gtob::Dto::RunOnceParameters'
TAG_GTOB_DTO_SIMPLE_PARAMETERS = 'Gtob::Dto::SimpleParameters'
TAG_GTOB_DTO_GFS_PARAMETERS = 'Gtob::Dto::GfsParameters'
TAG_GTOB_DTO_TOH_PARAMETERS = 'Gtob::Dto::TowerOfHanoiParameters'
TAG_GTOB_DTO_CUSTOM_PARAMETERS = 'Gtob::Dto::CustomParameters'
TAG_GTOB_DTO_DATE_TIME = 'Gtob::Dto::DateTime'
TAG_GTOB_DTO_BACKUP_SCHEDULE_ITEM = 'Gtob::Dto::BackupScheduleItem'
TAG_GTOB_DTO_SPECIFIC_PROTECTION_PARAMETERS = 'Gtob::Dto::SpecificProtectionParameters'
TAG_SCHEDULE_MANAGEMENT_ALARM = 'ScheduleManagement::Alarm'
TAG_SCHEDULE_MANAGEMENT_CALENDAR = 'ScheduleManagement::Calendar'

SCHEME_TITLES = {
    BACKUP_SCHEME_NOW: 'run now',
    BACKUP_SCHEME_ONCE: 'manual start',
    BACKUP_SCHEME_SIMPLE: 'simple',
    BACKUP_SCHEME_GFS: 'gfs',
    BACKUP_SCHEME_TOWER_OF_HANOI: 'toh',
    BACKUP_SCHEME_CUSTOM: 'custom',
}

SCHEME_PARAMETERS_CLASS_INFO = {
    BACKUP_SCHEME_NOW: TAG_GTOB_DTO_RUN_NOW_PARAMETERS,
    BACKUP_SCHEME_ONCE: TAG_GTOB_DTO_RUN_ONCE_PARAMETERS,
    BACKUP_SCHEME_SIMPLE: TAG_GTOB_DTO_SIMPLE_PARAMETERS,
    BACKUP_SCHEME_GFS: TAG_GTOB_DTO_GFS_PARAMETERS,
    BACKUP_SCHEME_TOWER_OF_HANOI: TAG_GTOB_DTO_TOH_PARAMETERS,
    BACKUP_SCHEME_CUSTOM: TAG_GTOB_DTO_CUSTOM_PARAMETERS
}

TIME_ALARM_CLASS_ID = 0x0001
LOGON_ALARM_CLASS_ID = 0x0002
LOGOFF_ALARM_CLASS_ID = 0x0004
STARTUP_ALARM_CLASS_ID = 0x0008
SHUTDOWN_ALARM_CLASS_ID = 0x0010
REBOOT_ALARM_CLASS_ID = 0x0020
POWEROFF_ALARM_CLASS_ID = 0x0040
SPACE_CHANGE_ALARM_CLASS_ID = 0x0080
TIME_SINCE_TASK_FINISHED_ALARM_CLASS_ID = 0x0100
TIME_SINCE_LAST_POLICY_BACKUP_ALARM_CLASS_ID = 0x0200
ONCE_ALARM_CLASS_ID = 0x0400
APPLICATIOIN_INSTALL_ALARM_CLASS_ID = 0x0800
EVENT_LOG_MESSAGE_ALARM_CLASS_ID = 0x1000
CUSTOM_ALARM_CLASS_ID = 0x2000

ALARM_CLASS_INFO = {
    TIME_ALARM_CLASS_ID: 'ScheduleManagement::TimeAlarm',
    LOGON_ALARM_CLASS_ID: 'ScheduleManagement::LogonAlarm',
    LOGOFF_ALARM_CLASS_ID: 'ScheduleManagement::LogoffAlarm',
    STARTUP_ALARM_CLASS_ID: 'ScheduleManagement::StartupAlarm',
    SHUTDOWN_ALARM_CLASS_ID: 'ScheduleManagement::ShutdownAlarm',
    REBOOT_ALARM_CLASS_ID: 'ScheduleManagement::RebootAlarm',
    POWEROFF_ALARM_CLASS_ID: 'ScheduleManagement::PowerOffAlarm',
    SPACE_CHANGE_ALARM_CLASS_ID: 'ScheduleManagement::SpaceChangeAlarm',
    TIME_SINCE_TASK_FINISHED_ALARM_CLASS_ID: 'ScheduleManagement::TimeSinceTaskFinishedAlarm',
    TIME_SINCE_LAST_POLICY_BACKUP_ALARM_CLASS_ID: 'ScheduleManagement::TimeSinceLastPolicyBackupAlarm',
    ONCE_ALARM_CLASS_ID: 'ScheduleManagement::OnceAlarm',
    APPLICATIOIN_INSTALL_ALARM_CLASS_ID: 'ScheduleManagement::ApplicationInstallAlarm',
    EVENT_LOG_MESSAGE_ALARM_CLASS_ID: 'ScheduleManagement::EventLogMessageAlarm',
    CUSTOM_ALARM_CLASS_ID: 'ScheduleManagement::CustomAlarm'
}

DAILY_CALENDAR_CLASS_ID = 0x01
WEEKLY_CALENDAR_CLASS_ID = 0x02
MONTHLY_DATE_CALENDAR_CLASS_ID = 0x04
MONTHLY_DAY_OF_WEEK_CALENDAR_CLASS_ID = 0x08
MONTHLY_PERIODIC_DATE_PERIODIC_CALENDAR_CLASS_ID = 0x10
MONTHLY_PERIODIC_DATE_MASK_CALENDAR_CLASS_ID = 0x20
MONTHLY_PERIODIC_DAY_OF_WEEK_CALENDAR_CLASS_ID = 0x40
MONTHLY_MASK_DATE_PERIODIC_CALENDAR_CLASS_ID = 0x80

CALENDAR_CLASS_INFO = {
    DAILY_CALENDAR_CLASS_ID: 'ScheduleManagement::DailyCalendar',
    WEEKLY_CALENDAR_CLASS_ID: 'ScheduleManagement::WeeklyCalendar',
    MONTHLY_DATE_CALENDAR_CLASS_ID: 'ScheduleManagement::MonthlyDate',
    MONTHLY_DAY_OF_WEEK_CALENDAR_CLASS_ID: 'ScheduleManagement::MonthlyDayOfWeek',
    MONTHLY_PERIODIC_DATE_PERIODIC_CALENDAR_CLASS_ID: 'ScheduleManagement::MonthlyPeriodicDatePeriodic',
    MONTHLY_PERIODIC_DATE_MASK_CALENDAR_CLASS_ID: 'ScheduleManagement::MonthlyPeriodicDateMask',
    MONTHLY_PERIODIC_DAY_OF_WEEK_CALENDAR_CLASS_ID: 'ScheduleManagement::MonthlyPeriodicDayOfWeek',
    MONTHLY_MASK_DATE_PERIODIC_CALENDAR_CLASS_ID: 'ScheduleManagement::MonthlyMaskDatePeriodic'
}

CONDITION_CLASS_INFO = {
    0x00001: 'ScheduleManagement::OnceADayCondition',
    0x00002: 'ScheduleManagement::AllUsersIdleCondition',
    0x00004: 'ScheduleManagement::DestinationAvailableCondition',
    0x00008: 'ScheduleManagement::TimeIntervalCondition',
    0x00010: 'ScheduleManagement::AllLoggedOffCondition',
    0x00020: 'ScheduleManagement::TimeSinceLastPolicyBackupCondition',
    0x00040: 'ScheduleManagement::OnceInLifeCondition',
    0x00100: 'ScheduleManagement::PowerCablePluggedInCondition',
    0x04000: 'ScheduleManagement::BatteryLevelEnoughCondition',
    0x10000: 'ScheduleManagement::IPRangesMatchedCondition',
    0x20000: 'ScheduleManagement::NotOnBannedWiFiCondition',
    0x40000: 'ScheduleManagement::NotOnMeteredConnectionCondition'
}

# Backup::Online::StorageApi enum from enterprise/backup/online/online_uri/include/online_uri.h
STORAGE_API_NONE = 0
STORAGE_API_ASTOR = 1
STORAGE_API_MICROSOFT_AZURE = 2
STORAGE_API_GOOGLE = 3
STORAGE_API_AMAZON_S3 = 4
STORAGE_API_S3_COMPATIBLE = 5
